<?php
// services.php

if (!isset($fromId)) return;

global $db;

// دکمه "سرویس‌های من"
if ($text == "👤 سرویس‌های من") {
    $s = $db['users'][$fromId]['services'] ?? [];
    if (empty($s)) {
        bot('sendMessage', [
            'chat_id' => $chatId,
            'text'    => "⚠️ شما هنوز هیچ سرویسی تهیه نکرده‌اید."
        ]);
    } else {
        bot('sendMessage', [
            'chat_id' => $chatId,
            'text'    => "👤 لیست سرویس‌های شما:"
        ]);

        foreach ($s as $idx => $v) {
            $link = normalizeSubscriptionUrl($v['link']);
            $txt  = "🔹 یوزرنیم: `{$v['username']}`\n🔗 لینک ساب:\n`$link`";

            $btns = [
                [
                    ['text' => "🔗 لینک",          'callback_data' => "svc_link_$idx"],
                    ['text' => "🧾 QR",            'callback_data' => "svc_qr_$idx"]
                ],
                [
                    ['text' => "ℹ️ اطلاعات سرویس", 'callback_data' => "svc_info_$idx"]
                ],
                [
                    ['text' => "🔄 بروزرسانی لینک", 'callback_data' => "svc_sync_$idx"],
                    ['text' => "🗑 حذف سرویس",      'callback_data' => "svc_del_$idx"]
                ]
            ];

            bot('sendMessage', [
                'chat_id'      => $chatId,
                'text'         => $txt,
                'parse_mode'   => 'Markdown',
                'reply_markup' => json_encode(['inline_keyboard' => $btns])
            ]);
        }
    }
}

// کال‌بک‌های سرویس
if ($data && strpos($data, 'svc_') === 0) {
    $parts = explode('_', $data); // svc,action,idx
    if (count($parts) < 3) return;

    $action = $parts[1];
    $idx    = (int)$parts[2];

    $services = $db['users'][$fromId]['services'] ?? [];
    if (!isset($services[$idx])) {
        bot('answerCallbackQuery', [
            'callback_query_id' => $callback['id'],
            'text'              => "سرویس یافت نشد.",
            'show_alert'        => true
        ]);
        return;
    }

    $svc = $services[$idx];

    // 🔗 نمایش لینک
    if ($action == 'link') {
        $link = normalizeSubscriptionUrl($svc['link']);
        bot('answerCallbackQuery', [
            'callback_query_id' => $callback['id'],
            'text'              => "لینک ارسال شد.",
            'show_alert'        => false
        ]);
        bot('sendMessage', [
            'chat_id'    => $chatId,
            'text'       => "🔗 لینک سرویس:\n`$link`",
            'parse_mode' => 'Markdown'
        ]);
    }

    // 🧾 QR Code
    if ($action == 'qr') {
        $link = normalizeSubscriptionUrl($svc['link']);
        $url  = getQrCodeUrl($link, 400);

        bot('sendPhoto', [
            'chat_id' => $chatId,
            'photo'   => $url,
            'caption' => "🧾 QR Code سرویس `{$svc['username']}`",
            'parse_mode' => 'Markdown'
        ]);
        bot('answerCallbackQuery', [
            'callback_query_id' => $callback['id'],
            'text'              => "QR برای شما ارسال شد.",
            'show_alert'        => false
        ]);
    }

    // ℹ️ اطلاعات سرویس از پنل
    if ($action == 'info') {
        $panelId = $svc['panel_id'] ?? null;
        if ($panelId === null) {
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback['id'],
                'text'              => "اطلاعات پنل برای این سرویس ثبت نشده.",
                'show_alert'        => true
            ]);
            return;
        }

        $info = getMarzbanUser($panelId, $svc['username']);
        if (!$info || isset($info['detail'])) {
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback['id'],
                'text'              => "خطا در دریافت اطلاعات از پنل.",
                'show_alert'        => true
            ]);
            return;
        }

        $limit   = $info['data_limit']    ?? null;
        $used    = $info['used_traffic']  ?? null;
        $expire  = $info['expire']        ?? null;

        $limitF  = $limit ? formatBytes($limit) : "نامشخص";
        $usedF   = $used ? formatBytes($used)   : "نامشخص";
        $remainF = ($limit && $used) ? formatBytes(max($limit - $used, 0)) : "نامشخص";
        $timeF   = formatRemainingTime($expire);

        $status = ($expire && $expire < time()) ? "⛔️ منقضی" : "✅ فعال";

        $txt = "ℹ️ اطلاعات سرویس `{$svc['username']}`:\n\n" .
               "📊 وضعیت: $status\n" .
               "📦 حجم کل: $limitF\n" .
               "📤 مصرف شده: $usedF\n" .
               "📥 باقیمانده: $remainF\n" .
               "⏰ زمان باقی‌مانده: $timeF";

        bot('answerCallbackQuery', [
            'callback_query_id' => $callback['id'],
            'text'              => "اطلاعات سرویس ارسال شد.",
            'show_alert'        => false
        ]);
        bot('sendMessage', [
            'chat_id'    => $chatId,
            'text'       => $txt,
            'parse_mode' => 'Markdown'
        ]);
    }

    // 🔄 بروزرسانی لینک
    if ($action == 'sync') {
        $panelId = $svc['panel_id'] ?? null;
        if ($panelId === null) {
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback['id'],
                'text'              => "پنل این سرویس مشخص نیست، امکان Sync نیست.",
                'show_alert'        => true
            ]);
            return;
        }

        $info = getMarzbanUser($panelId, $svc['username']);
        if (!$info || empty($info['subscription_url'])) {
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback['id'],
                'text'              => "خطا در دریافت لینک جدید از پنل.",
                'show_alert'        => true
            ]);
            return;
        }

        $newLink = normalizeSubscriptionUrl($info['subscription_url']);
        $db['users'][$fromId]['services'][$idx]['link'] = $newLink;
        saveDB();

        bot('answerCallbackQuery', [
            'callback_query_id' => $callback['id'],
            'text'              => "لینک سرویس بروزرسانی شد.",
            'show_alert'        => false
        ]);
        bot('sendMessage', [
            'chat_id'    => $chatId,
            'text'       => "🔄 لینک سرویس شما بروزرسانی شد:\n`$newLink`",
            'parse_mode' => 'Markdown'
        ]);
    }

    // 🗑 حذف سرویس
    if ($action == 'del') {
        $panelId = $svc['panel_id'] ?? null;
        $okPanel = false;
        if ($panelId !== null) {
            $okPanel = deleteMarzbanUser($panelId, $svc['username']);
        }

        unset($db['users'][$fromId]['services'][$idx]);
        $db['users'][$fromId]['services'] = array_values($db['users'][$fromId]['services']);
        saveDB();

        notifyAdmin("🗑 حذف سرویس:\n\nکاربر: $fromId\nیوزرنیم: {$svc['username']}\nنتیجه حذف از پنل: " . ($okPanel ? "موفق" : "نامشخص (panel_id نداشت یا خطا)"));

        bot('answerCallbackQuery', [
            'callback_query_id' => $callback['id'],
            'text'              => "سرویس شما حذف شد.",
            'show_alert'        => true
        ]);
        bot('sendMessage', [
            'chat_id' => $chatId,
            'text'    => "✅ سرویس شما حذف شد."
        ]);
    }
}