<?php
// store.php

if (!isset($fromId)) return;

global $db, $steps, $settings, $products, $panels, $adminMainBtns;

// --- STEP PROCESSING ---
if ($text && isset($steps[$fromId]) && $steps[$fromId] != 'none' && !in_array($text, $adminMainBtns ?? [])) {
    $s = $steps[$fromId];

    // پنل جدید
    if ($s == 'add_panel_name') {
        $steps[$fromId] = "add_p_url|$text";
        saveSteps($steps);
        bot('sendMessage', [
            'chat_id'    => $chatId,
            'text'       => "🔗 آدرس پنل (همراه با پورت و http):\nمثال: `http://5.44.10.2:8000`",
            'parse_mode' => 'Markdown'
        ]);
    } elseif (strpos($s, 'add_p_url|') === 0) {
        $name = explode('|', $s)[1];
        $steps[$fromId] = "add_p_user|$name|$text";
        saveSteps($steps);
        bot('sendMessage', [
            'chat_id' => $chatId,
            'text'    => "👤 نام کاربری ادمین پنل:"
        ]);
    } elseif (strpos($s, 'add_p_user|') === 0) {
        list($_t, $name, $url) = explode('|', $s);
        $steps[$fromId] = "add_p_pass|$name|$url|$text";
        saveSteps($steps);
        bot('sendMessage', [
            'chat_id' => $chatId,
            'text'    => "🔑 پسورد ادمین پنل:"
        ]);
    } elseif (strpos($s, 'add_p_pass|') === 0) {
        list($_t, $name, $url, $user) = explode('|', $s);
        $panels[] = [
            "name"     => $name,
            "url"      => $url,
            "user"     => $user,
            "pass"     => $text,
            "template" => "template"
        ];
        savePanels();
        $steps[$fromId] = 'none';
        saveSteps($steps);
        bot('sendMessage', [
            'chat_id'      => $chatId,
            'text'         => "✅ پنل با موفقیت اضافه شد. برای شروع فروش، آن را در لیست مدیریت پنل‌ها فعال کنید.",
            'reply_markup' => getAdminMenu()
        ]);
    } elseif (strpos($s, 'wait_template|') === 0) {
        $idx = (int)explode('|', $s)[1];
        $panels[$idx]['template'] = $text;
        savePanels();
        $steps[$fromId] = 'none';
        saveSteps($steps);
        bot('sendMessage', [
            'chat_id'      => $chatId,
            'text'         => "✅ یوزر الگو برای این پنل تنظیم شد.",
            'reply_markup' => getAdminMenu()
        ]);
    }

    // تنظیمات
    elseif ($s == 'set_card') {
        $settings['card_number'] = $text;
        saveSettings();
        $steps[$fromId] = 'none';
        saveSteps($steps);
        bot('sendMessage', [
            'chat_id'      => $chatId,
            'text'         => "✅ شماره کارت با موفقیت ثبت شد.",
            'reply_markup' => getAdminMenu()
        ]);
    } elseif ($s == 'set_tut') {
        $settings['tutorial'] = $text;
        saveSettings();
        $steps[$fromId] = 'none';
        saveSteps($steps);
        bot('sendMessage', [
            'chat_id'      => $chatId,
            'text'         => "✅ متن آموزش بروزرسانی شد.",
            'reply_markup' => getAdminMenu()
        ]);
    } elseif ($s == 'wait_t_mb' && is_numeric($text)) {
        $settings['trial_mb'] = (int)$text;
        saveSettings();
        $steps[$fromId] = 'none';
        saveSteps($steps);
        bot('sendMessage', [
            'chat_id'      => $chatId,
            'text'         => "✅ حجم تست ثبت شد.",
            'reply_markup' => getAdminMenu()
        ]);
    } elseif ($s == 'wait_t_hr' && is_numeric($text)) {
        $settings['trial_hours'] = (int)$text;
        saveSettings();
        $steps[$fromId] = 'none';
        saveSteps($steps);
        bot('sendMessage', [
            'chat_id'      => $chatId,
            'text'         => "✅ زمان تست ثبت شد.",
            'reply_markup' => getAdminMenu()
        ]);
    } elseif ($s == 'step_broad') {
        $steps[$fromId] = 'none';
        saveSteps($steps);
        bot('sendMessage', [
            'chat_id'      => $chatId,
            'text'         => "⏳ در حال ارسال پیام به کلیه کاربران...",
            'reply_markup' => getAdminMenu()
        ]);
        foreach ($db['users'] as $uid => $_ud) {
            bot('copyMessage', [
                'chat_id'      => $uid,
                'from_chat_id' => $chatId,
                'message_id'   => $message['message_id']
            ]);
        }
        bot('sendMessage', [
            'chat_id' => $chatId,
            'text'    => "✅ ارسال پیام همگانی پایان یافت."
        ]);
    }

    // افزودن محصول
    elseif ($s == 'p_name') {
        $steps[$fromId] = "p_price|$text";
        saveSteps($steps);
        bot('sendMessage', [
            'chat_id' => $chatId,
            'text'    => "قیمت (تومان):"
        ]);
    } elseif (strpos($s, 'p_price|') === 0) {
        $n = explode('|', $s)[1];
        $steps[$fromId] = "p_gb|$n|$text";
        saveSteps($steps);
        bot('sendMessage', [
            'chat_id' => $chatId,
            'text'    => "حجم (گیگ):"
        ]);
    } elseif (strpos($s, 'p_gb|') === 0) {
        list($_t, $n, $p) = explode('|', $s);
        $steps[$fromId] = "p_day|$n|$p|$text";
        saveSteps($steps);
        bot('sendMessage', [
            'chat_id' => $chatId,
            'text'    => "زمان (روز):"
        ]);
    } elseif (strpos($s, 'p_day|') === 0) {
        list($_t, $n, $p, $g) = explode('|', $s);
        $products[] = [
            "name"  => $n,
            "price" => (int)$p,
            "gb"    => (int)$g,
            "days"  => (int)$text
        ];
        saveProducts();
        $steps[$fromId] = 'none';
        saveSteps($steps);
        bot('sendMessage', [
            'chat_id'      => $chatId,
            'text'         => "✅ محصول جدید اضافه شد.",
            'reply_markup' => getAdminMenu()
        ]);
    }

    // کیف پول / پشتیبانی
    elseif ($s == 'charge_amt' && is_numeric($text)) {
        $steps[$fromId] = "proof|$text";
        saveSteps($steps);
        bot('sendMessage', [
            'chat_id'    => $chatId,
            'text'       => "💳 شماره کارت:\n`{$settings['card_number']}`\n\n💰 مبلغ: " . number_format($text) . " تومان\n\nلطفاً پس از واریز، تصویر فیش واریزی را ارسال کنید.",
            'parse_mode' => 'Markdown'
        ]);
    } elseif ($s == 'step_support') {
        bot('sendMessage', [
            'chat_id' => ADMIN_ID,
            'text'    => "📩 تیکت جدید از $fromId:\n\n$text"
        ]);
        bot('sendMessage', [
            'chat_id' => $chatId,
            'text'    => "✅ پیام شما برای مدیریت ارسال شد."
        ]);
        $steps[$fromId] = 'none';
        saveSteps($steps);
    }
}

// Proof Photo Capture
if (isset($message['photo']) && strpos(($steps[$fromId] ?? ''), 'proof|') === 0) {
    $amt = explode('|', $steps[$fromId])[1];
    $steps[$fromId] = 'none';
    saveSteps($steps);

    bot('sendMessage', [
        'chat_id' => $chatId,
        'text'    => "✅ فیش شما دریافت شد و برای ادمین ارسال گردید. لطفاً منتظر تایید بمانید."
    ]);

    bot('sendPhoto', [
        'chat_id' => ADMIN_ID,
        'photo'   => end($message['photo'])['file_id'],
        'caption' => "💰 فیش واریزی جدید\nکاربر: `$fromId`\nمبلغ: " . number_format($amt) . " تومان",
        'parse_mode' => 'Markdown',
        'reply_markup' => json_encode([
            'inline_keyboard' => [[
                ['text' => "✅ تایید", 'callback_data' => "payok_{$fromId}_{$amt}"],
                ['text' => "❌ رد",   'callback_data' => "payno"]
            ]]
        ])
    ]);
}

// --- MAIN BUTTONS ---
switch ($text) {
    case "🛒 خرید اشتراک":
        if (empty($products)) {
            bot('sendMessage', [
                'chat_id' => $chatId,
                'text'    => "⚠️ پلن فروشی موجود نیست."
            ]);
        } else {
            $btns = [];
            foreach ($products as $id => $p) {
                $btns[] = [[
                    'text'          => $p['name'] . " - " . number_format($p['price']) . " ت",
                    'callback_data' => "buy_p_$id"
                ]];
            }
            bot('sendMessage', [
                'chat_id'      => $chatId,
                'text'         => "📦 پلن مورد نظر را انتخاب کنید:",
                'reply_markup' => json_encode(['inline_keyboard' => $btns])
            ]);
        }
        break;

    case "🎁 تست رایگان":
        if ($db['users'][$fromId]['trial']) {
            bot('sendMessage', [
                'chat_id' => $chatId,
                'text'    => "❌ شما قبلاً هدیه تست خود را دریافت کرده‌اید."
            ]);
        } else {
            $aIdx = $settings['active_panel_idx'];
            if ($aIdx === null || !isset($panels[$aIdx])) {
                bot('sendMessage', [
                    'chat_id' => $chatId,
                    'text'    => "⚠️ سرویس تست در حال حاضر غیرفعال است."
                ]);
            } else {
                bot('sendMessage', [
                    'chat_id' => $chatId,
                    'text'    => "⏳ در حال ساخت اکانت تست..."
                ]);
                $panel = $panels[$aIdx];
                $token = Marzban::getToken($panel);
                if ($token) {
                    $temp     = $panel['template'];
                    $template = Marzban::call($panel, "/api/user/$temp", "GET", null, $token);
                    if (isset($template['proxies'])) {
                        $username = "trial_" . $fromId . "_" . rand(10, 99);
                        $payload  = [
                            "username"   => $username,
                            "proxies"    => $template['proxies'],
                            "inbounds"   => $template['inbounds'],
                            "data_limit" => $settings['trial_mb'] * 1048576,
                            "expire"     => time() + ($settings['trial_hours'] * 3600)
                        ];
                        $res = Marzban::call($panel, "/api/user", "POST", $payload, $token);
                        if (isset($res['subscription_url'])) {
                            $db['users'][$fromId]['trial']      = true;
                            $db['users'][$fromId]['services'][] = [
                                "username" => $username,
                                "link"     => $res['subscription_url'],
                                "panel_id" => $aIdx
                            ];
                            saveDB();

                            notifyAdmin("🎁 اکانت تست جدید ساخته شد:\n\nکاربر: $fromId\nیوزرنیم: $username\nپنل: {$panel['name']}");

                            bot('sendMessage', [
                                'chat_id'    => $chatId,
                                'text'       => "✅ اکانت تست شما ساخته شد:\n\n`{$res['subscription_url']}`",
                                'parse_mode' => 'Markdown'
                            ]);
                        } else {
                            bot('sendMessage', [
                                'chat_id' => $chatId,
                                'text'    => "❌ خطا در ساخت اکانت تست."
                            ]);
                        }
                    } else {
                        bot('sendMessage', [
                            'chat_id' => $chatId,
                            'text'    => "❌ یوزر الگو برای تست یافت نشد."
                        ]);
                    }
                } else {
                    bot('sendMessage', [
                        'chat_id' => $chatId,
                        'text'    => "❌ خطای اتصال به پنل."
                    ]);
                }
            }
        }
        break;

    case "💰 کیف پول":
        $bal = number_format($db['users'][$fromId]['balance']);
        bot('sendMessage', [
            'chat_id'      => $chatId,
            'text'         => "💰 موجودی کیف پول شما: $bal تومان",
            'reply_markup' => json_encode([
                'inline_keyboard' => [[
                    ['text' => "➕ شارژ حساب", 'callback_data' => "charge_wallet"]
                ]]
            ])
        ]);
        break;

    case "👥 زیرمجموعه‌گیری":
        $botUser = bot('getMe')['result']['username'];
        $link    = "https://t.me/$botUser?start=$fromId";
        $sc      = $db['users'][$fromId]['sub_count'] ?? 0;
        bot('sendMessage', [
            'chat_id'    => $chatId,
            'text'       => "👥 زیرمجموعه‌گیری\n\nتعداد زیرمجموعه شما: $sc نفر\n\nبا دعوت از دوستان، از خرید آن‌ها هدیه بگیرید.\n🔗 لینک اختصاصی شما:\n`$link`",
            'parse_mode' => 'Markdown'
        ]);
        break;

    case "📚 آموزش":
        bot('sendMessage', [
            'chat_id' => $chatId,
            'text'    => "📚 آموزش استفاده از سرویس‌ها:\n\n" . $settings['tutorial']
        ]);
        break;

    case "☎️ پشتیبانی":
        $steps[$fromId] = 'step_support';
        saveSteps($steps);
        bot('sendMessage', [
            'chat_id' => $chatId,
            'text'    => "لطفاً پیام خود را بنویسید تا برای تیم پشتیبانی ارسال شود:"
        ]);
        break;
}

// --- CALLBACKS (USER / STORE) ---
if ($data) {
    if ($data == 'charge_wallet') {
        $steps[$fromId] = 'charge_amt';
        saveSteps($steps);
        bot('sendMessage', [
            'chat_id' => $chatId,
            'text'    => "لطفاً مبلغ شارژ مورد نظر را به تومان وارد کنید:"
        ]);
    }

    if (strpos($data, 'buy_p_') === 0) {
        $id = str_replace('buy_p_', '', $data);
        if (!isset($products[$id])) return;

        $p = $products[$id];
        if ($db['users'][$fromId]['balance'] >= $p['price']) {
            $aIdx = $settings['active_panel_idx'];
            if ($aIdx === null || !isset($panels[$aIdx])) {
                bot('answerCallbackQuery', [
                    'callback_query_id' => $callback['id'],
                    'text'              => "❌ ادمین هنوز پنلی را برای فروش فعال نکرده است.",
                    'show_alert'        => true
                ]);
            } else {
                bot('answerCallbackQuery', [
                    'callback_query_id' => $callback['id'],
                    'text'              => "⏳ در حال ساخت اکانت..."
                ]);
                $panel = $panels[$aIdx];
                $token = Marzban::getToken($panel);
                if ($token) {
                    $temp     = $panel['template'];
                    $template = Marzban::call($panel, "/api/user/$temp", "GET", null, $token);
                    if (isset($template['proxies'])) {
                        $username = "m" . $fromId . "r" . rand(100, 999);
                        $payload  = [
                            "username"   => $username,
                            "proxies"    => $template['proxies'],
                            "inbounds"   => $template['inbounds'],
                            "data_limit" => $p['gb'] * 1073741824,
                            "expire"     => time() + ($p['days'] * 86400)
                        ];
                        $res = Marzban::call($panel, "/api/user", "POST", $payload, $token);
                        if (isset($res['subscription_url'])) {
                            $db['users'][$fromId]['balance']      -= $p['price'];
                            $db['users'][$fromId]['services'][]   = [
                                "username" => $username,
                                "link"     => $res['subscription_url'],
                                "panel_id" => $aIdx
                            ];
                            $db['stats']['total_sales']           += $p['price'];
                            saveDB();

                            notifyAdmin("🛒 خرید جدید:\n\nکاربر: $fromId\nپلن: {$p['name']}\nمبلغ: " . number_format($p['price']) . " تومان\nپنل: {$panel['name']}\nیوزرنیم: $username");

                            bot('sendMessage', [
                                'chat_id'    => $fromId,
                                'text'       => "✅ خرید موفق!\n\nلینک ساب:\n`{$res['subscription_url']}`",
                                'parse_mode' => 'Markdown'
                            ]);
                        } else {
                            bot('sendMessage', [
                                'chat_id' => $fromId,
                                'text'    => "❌ خطا در ساخت اکانت توسط پنل."
                            ]);
                        }
                    } else {
                        bot('sendMessage', [
                            'chat_id' => $fromId,
                            'text'    => "❌ یوزر الگو `$temp` در پنل مرزبان یافت نشد."
                        ]);
                    }
                } else {
                    bot('sendMessage', [
                        'chat_id' => $fromId,
                        'text'    => "❌ خطا در اتصال به پنل مرزبان."
                    ]);
                }
            }
        } else {
            bot('answerCallbackQuery', [
                'callback_query_id' => $callback['id'],
                'text'              => "❌ موجودی کیف پول کافی نیست.",
                'show_alert'        => true
            ]);
        }
    }

    if (strpos($data, 'payok_') === 0) {
        list($_t, $uid, $amt) = explode('_', $data);
        $db['users'][$uid]['balance'] += (int)$amt;
        saveDB();

        bot('sendMessage', [
            'chat_id' => $uid,
            'text'    => "✅ تراکنش تایید شد! مبلغ " . number_format($amt) . " تومان به حساب شما اضافه شد."
        ]);

        bot('editMessageCaption', [
            'chat_id'    => ADMIN_ID,
            'message_id' => $callback['message']['message_id'],
            'caption'    => "✅ این واریزی تایید شد."
        ]);
    }
}